/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.log;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.ftb.log.ILogListener;
import net.ftb.log.LogEntry;
import net.ftb.log.LogLevel;
import net.ftb.log.LogThread;
import net.ftb.log.LogType;

public class Logger {
    private static final List<ILogListener> listeners = new ArrayList<ILogListener>();
    private static final Vector<LogEntry> logEntries = new Vector();
    private static LogThread logThread = new LogThread(listeners);

    public static void log(LogEntry entry) {
        logEntries.add(entry);
        logThread.handleLog(entry);
    }

    public static void log(String message, LogLevel level, Throwable t) {
        Logger.log(new LogEntry().level(level).message(message).cause(t));
    }

    public static void logDebug(String message) {
        Logger.logDebug(message, null);
    }

    public static void logInfo(String message) {
        Logger.logInfo(message, null);
    }

    public static void logWarn(String message) {
        Logger.logWarn(message, null);
    }

    public static void logError(String message) {
        Logger.logError(message, null);
    }

    public static void logDebug(String message, Throwable t) {
        Logger.log(message, LogLevel.DEBUG, t);
    }

    public static void logInfo(String message, Throwable t) {
        Logger.log(message, LogLevel.INFO, t);
    }

    public static void logWarn(String message, Throwable t) {
        Logger.log(message, LogLevel.WARN, t);
    }

    public static void logError(String message, Throwable t) {
        Logger.log(message, LogLevel.ERROR, t);
    }

    public static void addListener(ILogListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(ILogListener listener) {
        listeners.remove(listener);
    }

    public static List<LogEntry> getLogEntries() {
        return new Vector<LogEntry>(logEntries);
    }

    public static String getLogs() {
        return Logger.getLogs(LogType.EXTENDED);
    }

    private static String getLogs(LogType type) {
        StringBuilder logStringBuilder = new StringBuilder();
        for (LogEntry entry : logEntries) {
            logStringBuilder.append(entry.toString(type)).append("\n");
        }
        return logStringBuilder.toString();
    }

    static {
        logThread.start();
    }
}

